#!/bin/bash
set -vx;
PATH=$PATH:.

echo '{ "test": "1" }' | jq  "." > /dev/null 2>&1;

if [ ! $? -eq 0 ]
then
	echo jq cannot be found
	exit;
fi


CLIENT_SECRET=`kubectl get secret -o jsonpath="{.data.secret}" sample-client |base64 -d`;

ACCESS_TOKEN=`curl -k -X POST -H "Content-Type: application/x-www-form-urlencoded" -u sample-client:$CLIENT_SECRET --data-urlencode grant_type=client_credentials https://$K8S_ENDPOINT/oauth/token | jq -r ".access_token"`;

curl     -k -X POST         --data-binary @demo/xes-sample/5010_270_x279_A1.dat -H "Authorization: Bearer $ACCESS_TOKEN" -H "Content-Type: text/plain" -o _result.zip https://$K8S_ENDPOINT/rest
