#!/bin/bash

PATH=$PATH:.

echo '{ "test": "1" }' | jq  "." > /dev/null 2>&1;

if [ ! $? -eq 0 ]
then
	echo jq cannot be found
	exit;
fi


TOKEN=`kubectl get secret -o jsonpath="{.data.secret}" sample-client |base64 -d`;

if [ -z $TOKEN ];
then
	XEC_TOKEN=`kubectl get secret -o jsonpath="{.data.token}" account-management |base64 -d`;

     	curl  -X POST -k -d '
              {
                  "name": "system/*.*",
                  "showInUserConsent": false
              }' -H "Content-Type: application/json" -H "Authorization: XEC-Token $XEC_TOKEN" https://$K8S_ENDPOINT/oauth-api/scopes;

	TOKEN=`curl  -X POST -k -d '{
            "enabled": true,
            "confidential": true,
            "clientId": "sample-client",
            "applicationName": "sampleclient",
            "applicationDescription": "",
            "applicationWebUri": "",
            "applicationLogoUri": "",
            "applicationLogoutUri": "",
            "applicationPolicyUri": "",
            "applicationTosUri": "",
            "allowedGrantTypes": [
                "client_credentials"
            ],
            "redirectUris": [],
            "registeredScopes": ["system/*.*"],
            "registeredAudiences": []
        }' -H "Content-Type: application/json" -H "Authorization: XEC-Token $XEC_TOKEN" https://$K8S_ENDPOINT/oauth-api/clients | jq -r ".clientSecret"`;

	[ -z $TOKEN ] || echo '
        apiVersion: v1
        stringData:
          secret: '$TOKEN'
        kind: Secret
        metadata:
          name: sample-client
        ' | kubectl apply -f -

fi;
